/**
 * All blocks that use the item sprite as their icon.
 *
 * Listed only blocks whose identifier is the same for both the item and the block.
 * There are cases where the two are different, such as the Redstone Repeater.
 * ---
 * Every commented ItemBlock is using **legacy** item data!
 *
 * We must wait for these ItemBlocks to be updated to the new form
 * or wait for a method where we can get the item data from them.
 */
export const MinecraftBlockItemTypes = [
  'minecraft:acacia_door',
  'minecraft:acacia_hanging_sign',
  'minecraft:activator_rail',
  'minecraft:amethyst_cluster',
  'minecraft:bamboo_door',
  'minecraft:bamboo_hanging_sign',
  'minecraft:bamboo',
  // 'minecraft:bed',
  'minecraft:bell',
  'minecraft:birch_door',
  'minecraft:birch_hanging_sign',
  'minecraft:black_candle',
  'minecraft:blue_candle',
  'minecraft:brain_coral',
  'minecraft:brewing_stand',
  'minecraft:brown_candle',
  'minecraft:brown_mushroom',
  'minecraft:bubble_coral',
  'minecraft:campfire',
  'minecraft:candle',
  'minecraft:cauldron',
  'minecraft:chain',
  'minecraft:cherry_door',
  'minecraft:cherry_hanging_sign',
  'minecraft:cherry_sapling',
  'minecraft:coral_fan_dead',
  'minecraft:coral_fan',
  'minecraft:crimson_door',
  'minecraft:crimson_fungus',
  'minecraft:crimson_hanging_sign',
  'minecraft:crimson_roots',
  'minecraft:cyan_candle',
  'minecraft:dark_oak_door',
  'minecraft:dark_oak_hanging_sign',
  'minecraft:dead_brain_coral',
  'minecraft:dead_bubble_coral',
  'minecraft:dead_fire_coral',
  'minecraft:dead_horn_coral',
  'minecraft:dead_tube_coral',
  'minecraft:deadbush',
  'minecraft:detector_rail',
  // 'minecraft:double_plant',
  'minecraft:fire_coral',
  'minecraft:flower_pot',
  'minecraft:frame',
  'minecraft:frog_spawn',
  'minecraft:gray_candle',
  'minecraft:glow_frame',
  'minecraft:glow_lichen',
  'minecraft:golden_rail',
  'minecraft:green_candle',
  'minecraft:hanging_roots',
  'minecraft:hopper',
  'minecraft:horn_coral',
  'minecraft:iron_bars',
  'minecraft:iron_door',
  'minecraft:iron_hanging_sign',
  'minecraft:jungle_door',
  'minecraft:jungle_hanging_sign',
  'minecraft:kelp',
  'minecraft:ladder',
  'minecraft:lantern',
  'minecraft:large_amethyst_bud',
  'minecraft:lever',
  'minecraft:light_blue_candle',
  'minecraft:light_gray_candle',
  'minecraft:lime_candle',
  'minecraft:magenta_candle',
  'minecraft:mangrove_door',
  'minecraft:mangrove_hanging_sign',
  'minecraft:medium_amethyst_bud',
  'minecraft:nether_sprouts',
  'minecraft:nether_wart',
  'minecraft:orange_candle',
  'minecraft:pink_candle',
  'minecraft:pink_petal',
  'minecraft:pitcher_plant',
  'minecraft:pointed_dripstone',
  'minecraft:purple_candle',
  'minecraft:rail',
  'minecraft:red_candle',
  // 'minecraft:red_flower',
  'minecraft:red_mushroom',
  'minecraft:redstone_torch',
  // 'minecraft:sapling',
  'minecraft:sea_pickle',
  'minecraft:seagrass',
  'minecraft:small_amethyst_bud',
  'minecraft:sniffer_egg',
  'minecraft:soul_campfire',
  'minecraft:soul_lantern',
  'minecraft:soul_torch',
  'minecraft:spruce_door',
  'minecraft:spruce_hanging_sign',
  // 'minecraft:tallgrass',
  'minecraft:torch',
  'minecraft:torchflower',
  'minecraft:tripwire_hook',
  'minecraft:tube_coral',
  'minecraft:turtle_egg',
  'minecraft:twisting_vines',
  'minecraft:vine',
  'minecraft:warped_door',
  'minecraft:warped_fungus',
  'minecraft:warped_hanging_sign',
  'minecraft:warped_roots',
  'minecraft:waterlily',
  'minecraft:web',
  'minecraft:weeping_vines',
  'minecraft:white_candle',
  'minecraft:wooden_door',
  'minecraft:yellow_candle',
  // 'minecraft:yellow_flower',
];
